/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.api.common.skill.IClickableSkill;
import dev.toma.gunsrpg.api.common.skill.ISkill;
import dev.toma.gunsrpg.api.common.skill.ISkillHierarchy;
import dev.toma.gunsrpg.api.common.skill.ISkillProperties;
import dev.toma.gunsrpg.api.common.skill.ITransactionValidator;
import dev.toma.gunsrpg.client.screen.skill.ExtensionsView;
import dev.toma.gunsrpg.client.screen.skill.IViewManager;
import dev.toma.gunsrpg.client.screen.skill.View;
import dev.toma.gunsrpg.client.screen.widgets.ContainerWidget;
import dev.toma.gunsrpg.client.screen.widgets.SkillWidget;
import dev.toma.gunsrpg.common.skills.core.DisplayData;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.C2S_SkillClickedPacket;
import dev.toma.gunsrpg.network.packet.C2S_UnlockSkillPacket;
import dev.toma.gunsrpg.util.ModUtils;
import dev.toma.gunsrpg.util.RenderUtils;
import dev.toma.gunsrpg.util.SkillUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SkillInfoWidget
extends ContainerWidget {
    private static final ITextComponent EXTENSIONS = new TranslationTextComponent("view.skill.extensions");
    private static final ITextComponent PURCHASE = new TranslationTextComponent("view.skill.purchase");
    private static final ITextComponent USE = new TranslationTextComponent("view.skill.use");
    private static final ITextComponent UNKNOWN = new TranslationTextComponent("view.skill.unknown");
    private static final ITextComponent NO_CONTENT = new TranslationTextComponent("screen.text.no_content");
    private final IViewManager manager;
    private SkillType<?> src;
    private ITextComponent title;
    private ITextComponent[] description;
    private boolean extensions;
    private boolean clickable;
    private Button buyWidget;
    private Button useWidget;

    public SkillInfoWidget(int x, int y, int width, int height, IViewManager manager) {
        super(x, y, width, height);
        this.manager = manager;
        this.init();
    }

    public void updateSource(SkillType<?> type) {
        this.src = type;
        this.clickable = false;
        if (this.src != null) {
            this.title = type.getTitle();
            this.description = type.getDescription();
            this.extensions = !ModUtils.isNullOrEmpty(type.getHierarchy().getExtensions());
            ISkillProvider provider = this.manager.getContext().getData().getSkillProvider();
            Object top = SkillUtil.getTopHierarchySkill(this.src, provider);
            this.clickable = this.src.getDataInstance() instanceof IClickableSkill && (top == null || top.getType().equals(this.src));
        }
        this.init();
    }

    @Override
    public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        Matrix4f pose = stack.func_227866_c_().func_227870_a_();
        RenderUtils.drawSolid(pose, this.field_230690_l_, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + this.field_230689_k_, -1426063360);
        super.func_230431_b_(stack, mouseX, mouseY, partialTicks);
    }

    private void init() {
        this.clear();
        if (this.src == null) {
            this.addWidget(new Label(this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, this.field_230689_k_, NO_CONTENT));
            return;
        }
        ISkillProperties properties = this.src.getProperties();
        boolean invisible = properties.getRequiredLevel() > this.manager.getContext().getData().getProgressData().getLevel();
        int unlockState = this.getUnlockState();
        this.addWidget(new Icon(this.field_230690_l_ + 5, this.field_230691_m_ + 5, 16, 16, invisible ? SkillWidget.UNKNOWN : this.src.getDisplayData()));
        this.addWidget(new Label(this.field_230690_l_ + 26, this.field_230691_m_ + 5, this.field_230688_j_ - 100, 15, invisible ? StringTextComponent.field_240750_d_ : this.title));
        int rightColX = this.field_230690_l_ + this.field_230688_j_ - 90;
        Button ext = this.addWidget(new Button(rightColX, this.field_230691_m_ + 5, 80, 20, EXTENSIONS, this::showExtensionsView));
        ext.field_230693_o_ = this.extensions;
        ext.field_230694_p_ = !invisible;
        this.buyWidget = this.addWidget(new Button(rightColX, this.field_230691_m_ + 27, 80, 20, PURCHASE, this::purchaseClicked));
        this.buyWidget.field_230693_o_ = !invisible && unlockState == 1;
        boolean bl = this.buyWidget.field_230694_p_ = !invisible && unlockState > 0;
        if (!invisible && this.clickable) {
            this.useWidget = this.addWidget(new Button(rightColX, this.field_230691_m_ + 27, 80, 20, USE, this::useClicked));
            this.useWidget.field_230694_p_ = unlockState == 0;
            this.useWidget.field_230693_o_ = false;
        }
        ITextComponent levelCondiditon = invisible ? StringTextComponent.field_240750_d_ : new TranslationTextComponent("view.skill.required_level", new Object[]{properties.getRequiredLevel()});
        ITextComponent price = invisible ? StringTextComponent.field_240750_d_ : new TranslationTextComponent("view.skill.price", new Object[]{properties.getPrice()});
        this.addWidget(new Label(rightColX, this.field_230691_m_ + 50, 80, 15, levelCondiditon));
        this.addWidget(new Label(rightColX, this.field_230691_m_ + 65, 80, 15, price));
        FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
        if (invisible) {
            this.addWidget(new Label(this.field_230690_l_ + 5, this.field_230691_m_ + 25, 100, 10, UNKNOWN));
            return;
        }
        int maxWidth = this.field_230688_j_ - 130;
        int lineIndex = 0;
        for (ITextComponent component : this.description) {
            List list = renderer.func_238425_b_((ITextProperties)component, maxWidth);
            for (IReorderingProcessor processor : list) {
                this.addWidget(new Label(this.field_230690_l_ + 5, this.field_230691_m_ + 25 + lineIndex++ * 10, maxWidth, 10, processor));
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.clickable && this.useWidget != null) {
            ISkillProvider provider = this.manager.getContext().getData().getSkillProvider();
            Object skill = SkillUtil.getTopHierarchySkill(this.src, provider);
            this.useWidget.field_230693_o_ = skill != null ? ((IClickableSkill)skill).canUse() : false;
        }
    }

    private void showExtensionsView(Button button) {
        int width = this.manager.getWidth();
        int height = this.manager.getHeight();
        View last = this.manager.getView();
        this.manager.setView(new ExtensionsView(width, height, this.manager, last, this.src));
    }

    private void useClicked(Button button) {
        NetworkManager.sendServerPacket(new C2S_SkillClickedPacket(this.validateSourceClickable()));
        this.useWidget.field_230693_o_ = false;
    }

    private void purchaseClicked(Button button) {
        NetworkManager.sendServerPacket(new C2S_UnlockSkillPacket(this.src));
        this.buyWidget.field_230694_p_ = false;
        if (this.clickable) {
            this.useWidget.field_230694_p_ = true;
        }
    }

    private int getUnlockState() {
        IPlayerData data = this.manager.getContext().getData();
        ISkillProperties properties = this.src.getProperties();
        ISkillHierarchy<?> hierarchy = this.src.getHierarchy();
        ITransactionValidator validator = properties.getTransactionValidator();
        ISkillProvider provider = data.getSkillProvider();
        SkillType<?> parentType = hierarchy.getParent();
        if (provider.hasSkill(this.src)) {
            return 0;
        }
        return (parentType == null || provider.hasSkill(parentType)) && validator.canUnlock(data, this.src) ? 1 : 2;
    }

    private <S extends ISkill & IClickableSkill, T extends SkillType<S>> T validateSourceClickable() {
        Object skill = this.src.getDataInstance();
        if (skill instanceof IClickableSkill) {
            return (T)((Object)this.src);
        }
        throw new IllegalArgumentException("Attempted to send C2S click event with unlickable skill type [" + this.src + "]");
    }

    private static class Icon
    extends Widget {
        final DisplayData data;

        Icon(int x, int y, int width, int height, DisplayData data) {
            super(x, y, width, height, StringTextComponent.field_240750_d_);
            this.data = data;
        }

        public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            this.data.renderAt(matrix, this.field_230690_l_, this.field_230691_m_);
        }
    }

    private static class Label
    extends Widget {
        private IReorderingProcessor drawable;

        Label(int x, int y, int width, int height, ITextComponent label) {
            super(x, y, width, height, label);
        }

        Label(int x, int y, int width, int height, IReorderingProcessor processor) {
            this(x, y, width, height, StringTextComponent.field_240750_d_);
            this.drawable = processor;
        }

        public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
            float yCenter = RenderUtils.getVerticalCenter(renderer, this);
            if (this.drawable == null) {
                renderer.func_243246_a(matrix, this.func_230458_i_(), (float)this.field_230690_l_, yCenter, 0xFFFFFF);
            } else {
                renderer.func_238407_a_(matrix, this.drawable, (float)this.field_230690_l_, yCenter, 0xFFFFFF);
            }
        }
    }
}

